<?php if ( ! function_exists( 'gpur_metaboxes_settings' ) ) {
	function gpur_metaboxes_settings() {

		$settings = array();
		
		if ( 'allowed' === gpur_permissions( 'specific-roles', array_filter( gpur_option( 'review_management' ) ) ) ) { 

			if ( ! isset( $_GET['post_type'] ) OR ( isset( $_GET['post_type'] ) && 'gpur-template' !== $_GET['post_type'] ) ) {
				
				/**
				 * Review Settings
				 *
				 */
				$review = array();
				
				$review[] = array(
					'id' => 'gpur_show_review_template',
					'title' => esc_html__( 'Show Review Template', 'gpur' ),
					'desc' => esc_html__( 'Show the review template for this page if it has been automatically inserted.', 'gpur' ),
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'gpur' ),
						'disabled' => esc_html__( 'Disabled', 'gpur' ),
					),
					'default' => 'enabled',
					'class' => '',
				);

				$review[] = array( 
					'id' => 'gpur_site_rating_data',
					'title' => esc_html__( 'Site Rating', 'gpur' ),
					'type' => 'multi_text',
				);
				
				$review[] = array( 
					'id' => 'gp_override_average_rating',
					'title' => esc_html__( 'Override Average Rating', 'gpur' ),
					'desc' => esc_html__( 'Override the average site rating criteria.', 'gpur' ),
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'gpur' ),
						'disabled' => esc_html__( 'Disabled', 'gpur' ),
					),
					'default' => 'disabled',
				);

				$review[] = array( 
					'id' => 'gpur_site_rating',
					'title' => esc_html__( 'Average Rating', 'gpur' ),
					'type' => 'text',
					'conditions' => array(
						'gp_override_average_rating' => 'enabled',
					),
				);
					
				$review[] = array(  
					'id' => 'gpur_excerpt',
					'title' => esc_html__( 'Excerpt', 'gpur' ),
					'description' => esc_html__( 'The text displayed in the Excerpt element.', 'gpur' ),
					'type' => 'textarea',
					'validate' => 'html_custom',
					'allowed_html' => array(
						'a' => array(
							'href' => array(),
							'title' => array()
						),
						'div' => array(
							'class' => array(),
						),
						'br' => array(),
						'em' => array(),
						'strong' => array()
					),
				);
																	
				$review[] = array(  
					'id' => 'gpur_summary',
					'title' => esc_html__( 'Summary', 'gpur' ),
					'description' => esc_html__( 'The text displayed in the Summary element.', 'gpur' ),
					'type' => 'textarea',
					'validate' => 'html_custom',
					'allowed_html' => array(
						'a' => array(
							'href' => array(),
							'title' => array()
						),
						'div' => array(
							'class' => array(),
						),
						'br' => array(),
						'em' => array(),
						'strong' => array()
					),
				);

				$review[] = array( 
					'id' => 'gpur_good_points',
					'title' => esc_html__( 'Good Points', 'gpur' ),
					'type' => 'multi_text',
					'add_text' => esc_html__( 'Add', 'gpur' ),
					'default' => '',
				);

				$review[] = array( 
					'id' => 'gpur_bad_points',
					'title' => esc_html__( 'Bad Points', 'gpur' ),
					'type' => 'multi_text',
					'add_text' => esc_html__( 'Add', 'gpur' ),
					'default' => '',
				);

				$review[] = array( 
					'id' => 'gpur_review_image_1',
					'title' => esc_html__( 'Review Image 1', 'gpur' ),
					'description' => esc_html__( 'This image is used when displaying images in review templates.', 'gpur' ),
					'type' => 'media',
					'format' => 'image',
					'default' => '',
				);

				$review[] = array( 
					'id' => 'gpur_review_image_2',
					'title' => esc_html__( 'Review Image 2', 'gpur' ),
					'description' => esc_html__( 'This is an alternative image is used when displaying images in review templates.', 'gpur' ),
					'type' => 'media',
					'format' => 'image',
					'default' => '',
				);

				$review[] = array( 
					'id' => 'gpur_review_button_text',
					'title' => esc_html__( 'Review Button Text', 'gpur' ),
					'description' => esc_html__( 'This is the text used for buttons in review templates - leave empty to use the text set in the Review Button element.', 'gpur' ),
					'type' => 'text',
					'default' => '',
				);

				$review[] = array( 
					'id' => 'gpur_review_button_link',
					'title' => esc_html__( 'Review Button Link', 'gpur' ),
					'description' => esc_html__( 'This is the link used for buttons in review templates - leave empty to use the link set in the Review Button element.', 'gpur' ),
					'type' => 'text',
					'default' => '',
				);
			
		
				$settings[] = array(
					'id' => 'gpur-review',
					'title' => esc_html__( 'Review Settings', 'gpur' ),
					'post_types' => array_filter( gpur_option( 'review_post_types' ) ),
					'position' => 'normal',
					'priority' => 'high',
					'section' => $review
				);
				
			}
					
			/**
			 * Template Settings
			 *
			 */	 
			$template = array(

				array(
					'id' => 'gpur_review_template_automatic_insertion',
					'title' => esc_html__( 'Automatic Insertion', 'gpur' ),
					'desc' => esc_html__( 'Choose which post types to automatically display this review template. You can also insert review templates manually using the Review Template page builder element.', 'gpur' ),
					'data' => 'post_types',
					'type' => 'checkbox',
				),
				
				array(
					'id' => 'gpur_review_template_automatic_insertion_ids',
					'title' => esc_html__( 'Post/Page IDs', 'gpur' ),
					'desc' => esc_html__( 'Enter the IDs of the post/pages you want to show this template on - separate each ID with a comma e.g. 123, 456, 789', 'gpur' ),
					'type' => 'text',
					'conditions' => array(
						'gpur_review_template_automatic_insertion' => array(
							'operator' => 'not_empty',
						),	
					),
				),
				
				array(
					'id' => 'gpur_review_template_automatic_insertion_cats',
					'title' => esc_html__( 'Categories', 'gpur' ),
					'desc' => esc_html__( 'Enter the category slugs for the posts you want to show this template on - separate slugs with a comma e.g. category-1, category-2, category-3', 'gpur' ),
					'type' => 'text',			
					'conditions' => array(
						'gpur_review_template_automatic_insertion' => array(
							'operator' => 'not_empty',
						),	
					),
				),
				
				array(
					'id' => 'gpur_review_template_automatic_insertion_tags',
					'title' => esc_html__( 'Tags', 'gpur' ),
					'desc' => esc_html__( 'Enter the tag slugs for the posts you want to show this template on - separate slugs with a comma e.g. tag-1, tag-2, tag-3.', 'gpur' ),
					'type' => 'text',			
					'conditions' => array(
						'gpur_review_template_automatic_insertion' => array(
							'operator' => 'not_empty',
						),	
					),
				),
				
				array(
					'id' => 'gpur_review_template_position',
					'title' => esc_html__( 'Position', 'gpur' ),
					'desc' => esc_html__( 'Choose where to display your review template if it\'s automatically inserted.', 'gpur' ),
					'type' => 'select',	
					'options' => array(
						'top' => esc_html__( 'Top', 'gpur' ),
						'bottom' => esc_html__( 'Bottom', 'gpur' ),
					),
					'default' => 'bottom',				
					'conditions' => array(
						'gpur_review_template_automatic_insertion' => array(
							'operator' => 'not_empty',
						),	
					),
				),					
			
			);
			$settings[] = array(
				'id' => 'gpur-template',
				'title' => esc_html__( 'Template Settings', 'gpur' ),
				'post_types' => array( 'gpur-template' ),
				'position' => 'side',
				'priority' => 'high',
				'section' => $template
			);
			
			$settings = apply_filters( 'gpur_metaboxes_settings', $settings );

			return $settings;

		}
		
	}					
}